package gov.va.med.mhv.bluebutton.transfer;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SendRequestsStatusDTO  implements Serializable {

	private static final long serialVersionUID = -5425179996942218370L;
	
	public static final String MESSAGE_SENT = "Message sent";
	public static final String MESSAGE_FAILED = "Message delivery failed";
	public static final String MESSAGE_SUCCESSFUL = "Message delivery successful";
	public static final String UNKNOWN = "Unknown";

	private Date sendDate;
	private String sentTo;
	private String deliveryStatus;

	
	public SendRequestsStatusDTO() {
		// do nothing
	}
	
	public SendRequestsStatusDTO(DirectMessageDTO directMessage) {
		setSendDate(directMessage.getCreatedDate());
		setSentTo(directMessage.getSentToEmailAddress());
		setDeliveryStatus(directMessage.getDirectMessageStatus());
	}
	
	
	public Date getSendDate() {
		return sendDate;
	}

	public final void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	public String getformattedSendDate() {
		Date date = getSendDate();
		
		if(date != null) {
			SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy '@' HHmm");
			return formatter.format(date);
		}
		else
			return UNKNOWN;
	}
	
	public String getSentTo() {
		return sentTo;
	}

	public final void setSentTo(String sentTo) {
		if (sentTo == null) {
			this.sentTo = "";
		}
		else {
			this.sentTo = sentTo;
		}
	}

	
	public String getDeliveryStatus() {
		return deliveryStatus;
	}

	public final void setDeliveryStatus(String deliveryStatus) {
		if (deliveryStatus == null) {
			this.deliveryStatus ="";
		}
		else if (MESSAGE_SENT.equals(deliveryStatus)) {
			this.deliveryStatus = "Message successfully sent to the recipient's Direct Messaging system.";
		}
		else if (MESSAGE_SUCCESSFUL.equals(deliveryStatus)) {
			this.deliveryStatus = "Message successfully delivered to the recipient's Direct Messaging system.";
		}
		else if (MESSAGE_FAILED.equals(deliveryStatus)) {
			this.deliveryStatus = "Message not successfully delivered to the recipient's Direct system.";
		}
		else {
			this.deliveryStatus = deliveryStatus;
		}
	}

}
